#import "TWWebViewController.h"

@implementation TWWebViewController

- (id) initWithURL:(NSURL *)url {
	if (!(self = [super init]))
		return nil;
	
	_webView = [[UIWebView alloc] initWithFrame:CGRectZero];
	_webView.autoresizingMask = (UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleWidth);
	_webView.delegate = self;
	
	[_webView loadRequest:[NSURLRequest requestWithURL:url]];
	
	return self;
}

- (UIStatusBarStyle)preferredStatusBarStyle
{
	return UIStatusBarStyleDefault;
}

- (void) dealloc {
	_webView.delegate = nil;
	[_webView stopLoading];
}

- (void)dismissModalWebViewController
{
	[self.presentingViewController dismissViewControllerAnimated:YES completion:NULL];
}

- (void) setShowBrowserButton:(BOOL)showBrowserButton
{
	if (_showBrowserButton != showBrowserButton) {
		
		_showBrowserButton = showBrowserButton;
		if (_showBrowserButton) {
			self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:TKLocalizedString(@"Open Browser",@"View page in web browser button title") style:UIBarButtonItemStylePlain target:self action:@selector(openPageInBrowser)];
		}
		else {
			self.navigationItem.rightBarButtonItem = nil;
		}
	}
}

- (void) openPageInBrowser
{
	NSURL *currentURL = _webView.request.URL;
	
	if (currentURL) {
		
		[[UIApplication sharedApplication] openURL:currentURL];
	}
}

#pragma mark -

- (void) viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
	
	self.navigationController.navigationBar.barTintColor = [UIColor twitchProfileHeaderColorCollapsed];
	self.navigationController.navigationBar.tintColor = [UIColor twitchPurpleColor];
	self.navigationController.navigationBar.titleTextAttributes = @{NSFontAttributeName:[UIFont twitchNavigationBarTitleFont],NSForegroundColorAttributeName:[UIColor twitchPurpleColor]};
}

- (void) loadView {
	_webView.frame = [UIScreen mainScreen].bounds;
	
	self.view = _webView;
}

#pragma mark -

- (NSUInteger)supportedInterfaceOrientations
{
	return UIInterfaceOrientationMaskAll;
}

@end

#pragma mark -

@implementation UINavigationController (WebViewControllerPresentation)
+ (UINavigationController *) webNavigationControllerWithURL:(NSURL *) url {
	TWWebViewController *webViewController = [[TWWebViewController alloc] initWithURL:url];
	UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:webViewController];
	webViewController.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:TKLocalizedString(@"Done", @"Done button title") style:UIBarButtonItemStylePlain target:webViewController action:@selector(dismissModalWebViewController)];
	
	return navigationController;
}
@end
